import { T } from "@tldraw/validate";
import { vecModelValidator } from "../misc/geometry-types.mjs";
import { createBindingPropsMigrationSequence } from "../records/TLBinding.mjs";
import { arrowShapeVersions } from "../shapes/TLArrowShape.mjs";
const arrowBindingProps = {
  terminal: T.literalEnum("start", "end"),
  normalizedAnchor: vecModelValidator,
  isExact: T.boolean,
  isPrecise: T.boolean
};
const arrowBindingVersions = {};
const arrowBindingMigrations = createBindingPropsMigrationSequence({
  sequence: [{ dependsOn: [arrowShapeVersions.ExtractBindings] }]
});
export {
  arrowBindingMigrations,
  arrowBindingProps,
  arrowBindingVersions
};
//# sourceMappingURL=TLArrowBinding.mjs.map
